#include <stdio.h>
#include <string.h>
#include "sys.h"
#include "delay.h"   
#include "spi.h"
#include "usart.h"
#include "flash.h" 
#include "main.h"
#include "lcd.h"
#include "interface.h"

u8 is_Fread;
extern LCD_CONFIG lcdconfig;	
u32 pic_start_addr=4096<<2;
PIC_INFO pic_info;	

void SPI_Flash_Init(void)	//flashʼ
{
	RCC->APB2ENR|=1<<2;       //PORTAʱʹ 	    
	GPIOA->CRL&=0XFFF000FF; 
	GPIOA->CRL|=0X00033300;//PA2.3.4  	    
	GPIOA->ODR|=0X7<<2;    //PA2.3.4
	SPIx_Init();
}  
//==============================================
u8 SPI_Flash_ReadSR(void)   
{  
	u8 byte=0;   
	SPI_FLASH_CS=0;                            //ʹ   
	SPIx_ReadWriteByte(W25X_ReadStatusReg);    //Ͷȡ״̬Ĵ    
	byte=SPIx_ReadWriteByte(0Xff);             //ȡһֽ  
	SPI_FLASH_CS=1;                            //ȡƬѡ     
	return byte;   
} 
//ȴ
void SPI_Flash_Wait_Busy(void)   
{ 
	while ((SPI_Flash_ReadSR()&0x01)==0x01);   // ȴBUSYλ
}  
unsigned char pic_data[2];
void DisPic_Windows_From_FLASH(u32 ReadAddr,u32 NumByteToRead) 
{
	u32 j;
	LCD_CS_CLR;
	LCD_RS_SET;
	LCD_RD_SET;
	SPI_Flash_Init();
	for(j=0;j<NumByteToRead;j++)
	{
    SPI_FLASH_CS=0;                            //ʹ 
    SPIx_ReadWriteByte(W25X_ReadData);         //Ͷȡ 
    //	SPIx_ReadWriteByte(W25X_FastReadData); 	
    SPIx_ReadWriteByte((u8)((ReadAddr+(j))>>16));  //24bitַ    
    SPIx_ReadWriteByte((u8)((ReadAddr+(j))>>8));   
    SPIx_ReadWriteByte((u8)ReadAddr+(j));

    //pic_data[0]=SPIx_ReadWriteByte(0XFF);		//dummy

    pic_data[0]=SPIx_ReadWriteByte(0XFF);   //ѭ 
    pic_data[1]=SPIx_ReadWriteByte(0XFF);  
    SPI_FLASH_CS=0;   

    DATAOUT((pic_data[0])); 
    LCD_WR_CLR;
    LCD_WR_SET;

    DATAOUT((pic_data[1]));
    LCD_WR_CLR;
    LCD_WR_SET;
	} 
  LCD_CS_SET;
  SPI_FLASH_CS=1;                                //ȡƬѡ 
}
void Disp_Flash_Pic_9b_Num(u8 num)	//H9BITȡͼƬ
{
	Read_FlashPic_9b(lcdconfig.pic_bytes*num + pic_start_addr,lcdconfig.pic_bytes); 
}
void Read_FlashPic_9b(u32 ReadAddr,u32 NumByteToRead)  	//H9BITȡͼƬ 
{ 
	u32 i;
	int data_r,data_g,data_b;
	int data_first_9bit,data_second_9bit;
	BlockWrite(lcdconfig.col_pre,lcdconfig.col+lcdconfig.col_pre-1,lcdconfig.row_pre,lcdconfig.row+lcdconfig.row_pre-1);

    SPI_FLASH_CS=0;                              //ʹ 
		LCD_RD_SET;
		LCD_RS_SET;
		LCD_CS_CLR;
	
    SPIx_ReadWriteByte(W25X_ReadData);         //Ͷȡ   
    SPIx_ReadWriteByte((u8)((ReadAddr)>>16));  //24bitַ    
    SPIx_ReadWriteByte((u8)((ReadAddr)>>8));   
    SPIx_ReadWriteByte((u8)ReadAddr);  	
	
		for(i=0;i<NumByteToRead/3;i++)
		{ 
			data_r=(SPIx_ReadWriteByte(0XFF));
			data_g=(SPIx_ReadWriteByte(0XFF));
			data_b=(SPIx_ReadWriteByte(0XFF));
			
			
			data_first_9bit=((data_r&0xfc)<<8)|(((data_g&0xe0)<<2));
			data_second_9bit=((data_g&0x1c)<<11)|((data_b&0x00fc)<<5);		   
			

			DATAOUT(data_first_9bit);
			LCD_WR_CLR;
			LCD_WR_SET;
			
			DATAOUT(data_second_9bit);
			LCD_WR_CLR;
			LCD_WR_SET;
		} 
		SPI_FLASH_CS=1;                              //ȡƬѡ 
		LCD_CS_SET;
	}
void Disp_Flash_Pic_Num(u8 num)   	//ŴFlashȡͼƬһΪ0
{ 
		u32 i;
		u8 data_h,data_l; 
		u32 ReadAddr;
		u32 NumByteToRead;
	
		//ַΪlcdһͼƬֽxͼƬ
		ReadAddr=lcdconfig.pic_bytes*num + pic_start_addr;	//1
		NumByteToRead=lcdconfig.pic_bytes;
		BlockWrite(lcdconfig.col_pre,lcdconfig.col+lcdconfig.col_pre-1,lcdconfig.row_pre,lcdconfig.row+lcdconfig.row_pre-1);
		SPI_FLASH_CS=0;                              //ʹ 
		LCD_RD_SET;
		LCD_RS_SET;
		LCD_CS_CLR;
		is_Fread=1;
    SPIx_ReadWriteByte(W25X_ReadData);         //Ͷȡ   
    SPIx_ReadWriteByte((u8)((ReadAddr)>>16));  //24bitַ    
    SPIx_ReadWriteByte((u8)((ReadAddr)>>8));   
    SPIx_ReadWriteByte((u8)ReadAddr);  	
		for(i=0;i<(NumByteToRead>>1);i++)
		{ 
			data_h=	(SPIx_ReadWriteByte(0XFF));
			data_l=(SPIx_ReadWriteByte(0XFF));
			SendData(((u16)(data_h)<<8)|(data_l));
		} 
		SPI_FLASH_CS=1;                              //ȡƬѡ 
		LCD_CS_SET;
		is_Fread=0;
}

